/* If b, c, d are the lengths of the sides of an isosceles
   triangle, with c=d, then draw the triangle with its base
   at (x,y)--(x+b,y) and pointing up. Use Graphics g.
   */
public void drawIsosceles(Graphics g, int b, int c,
                          int d, int x, int y) {
   if (b <= 0 || c <= 0 || d <= 0) {
      return;
   }
   if (b+c < d || b+d < c || c+d < b) {
      return;
   }
   if (c != d) return;
   int h= (int) Math.sqrt(b*b/4 + c*c); // Height of
                                        // triangle
   g.drawLine(x,y, x+b,y);
   g.drawLine(x,y, x+b/2, y-h);
   g.drawLine(x+b,y, x+b/2, y-h);
}
